package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.IntervalInSeconds
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InterpolationParameters(
    interpolationType: Option[zio.aws.iottwinmaker.model.InterpolationType] =
      None,
    intervalInSeconds: Option[IntervalInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.InterpolationParameters = {
    import InterpolationParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.InterpolationParameters
      .builder()
      .optionallyWith(interpolationType.map(value => value.unwrap))(
        _.interpolationType
      )
      .optionallyWith(
        intervalInSeconds.map(value =>
          IntervalInSeconds.unwrap(value): java.lang.Long
        )
      )(_.intervalInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.InterpolationParameters.ReadOnly =
    zio.aws.iottwinmaker.model.InterpolationParameters.wrap(buildAwsValue())
}
object InterpolationParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.InterpolationParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.InterpolationParameters =
      zio.aws.iottwinmaker.model.InterpolationParameters(
        interpolationType.map(value => value),
        intervalInSeconds.map(value => value)
      )
    def interpolationType: Option[zio.aws.iottwinmaker.model.InterpolationType]
    def intervalInSeconds: Option[IntervalInSeconds]
    def getInterpolationType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.InterpolationType] =
      AwsError.unwrapOptionField("interpolationType", interpolationType)
    def getIntervalInSeconds: ZIO[Any, AwsError, IntervalInSeconds] =
      AwsError.unwrapOptionField("intervalInSeconds", intervalInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.InterpolationParameters
  ) extends zio.aws.iottwinmaker.model.InterpolationParameters.ReadOnly {
    override val interpolationType
        : Option[zio.aws.iottwinmaker.model.InterpolationType] = scala
      .Option(impl.interpolationType())
      .map(value => zio.aws.iottwinmaker.model.InterpolationType.wrap(value))
    override val intervalInSeconds: Option[IntervalInSeconds] = scala
      .Option(impl.intervalInSeconds())
      .map(value =>
        zio.aws.iottwinmaker.model.primitives.IntervalInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.InterpolationParameters
  ): zio.aws.iottwinmaker.model.InterpolationParameters.ReadOnly = new Wrapper(
    impl
  )
}
