package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Name,
  Description,
  ComponentTypeId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ComponentUpdateRequest(
    componentTypeId: Option[ComponentTypeId] = None,
    description: Option[Description] = None,
    propertyUpdates: Option[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest]
    ] = None,
    updateType: Option[zio.aws.iottwinmaker.model.ComponentUpdateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest = {
    import ComponentUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest
      .builder()
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        propertyUpdates.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyUpdates)
      .optionallyWith(updateType.map(value => value.unwrap))(_.updateType)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ComponentUpdateRequest.wrap(buildAwsValue())
}
object ComponentUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ComponentUpdateRequest =
      zio.aws.iottwinmaker.model.ComponentUpdateRequest(
        componentTypeId.map(value => value),
        description.map(value => value),
        propertyUpdates.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        updateType.map(value => value)
      )
    def componentTypeId: Option[ComponentTypeId]
    def description: Option[Description]
    def propertyUpdates
        : Option[Map[Name, zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly]]
    def updateType: Option[zio.aws.iottwinmaker.model.ComponentUpdateType]
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPropertyUpdates: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyUpdates", propertyUpdates)
    def getUpdateType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.ComponentUpdateType] =
      AwsError.unwrapOptionField("updateType", updateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest
  ) extends zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly {
    override val componentTypeId: Option[ComponentTypeId] = scala
      .Option(impl.componentTypeId())
      .map(value =>
        zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val propertyUpdates: Option[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly]
    ] = scala
      .Option(impl.propertyUpdates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyRequest.wrap(value)
          })
          .toMap
      )
    override val updateType
        : Option[zio.aws.iottwinmaker.model.ComponentUpdateType] = scala
      .Option(impl.updateType())
      .map(value => zio.aws.iottwinmaker.model.ComponentUpdateType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest
  ): zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly = new Wrapper(
    impl
  )
}
