package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListWorkspacesResponse(
    nextToken: Option[NextToken] = None,
    workspaceSummaries: Option[
      Iterable[zio.aws.iottwinmaker.model.WorkspaceSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse = {
    import ListWorkspacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        workspaceSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workspaceSummaries)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListWorkspacesResponse.ReadOnly =
    zio.aws.iottwinmaker.model.ListWorkspacesResponse.wrap(buildAwsValue())
}
object ListWorkspacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListWorkspacesResponse =
      zio.aws.iottwinmaker.model.ListWorkspacesResponse(
        nextToken.map(value => value),
        workspaceSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def workspaceSummaries
        : Option[List[zio.aws.iottwinmaker.model.WorkspaceSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkspaceSummaries: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.WorkspaceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("workspaceSummaries", workspaceSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse
  ) extends zio.aws.iottwinmaker.model.ListWorkspacesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val workspaceSummaries
        : Option[List[zio.aws.iottwinmaker.model.WorkspaceSummary.ReadOnly]] =
      scala
        .Option(impl.workspaceSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.WorkspaceSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse
  ): zio.aws.iottwinmaker.model.ListWorkspacesResponse.ReadOnly = new Wrapper(
    impl
  )
}
