package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Timestamp, TwinMakerArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateWorkspaceResponse(
    arn: TwinMakerArn,
    creationDateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceResponse = {
    import CreateWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceResponse
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.CreateWorkspaceResponse.ReadOnly =
    zio.aws.iottwinmaker.model.CreateWorkspaceResponse.wrap(buildAwsValue())
}
object CreateWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateWorkspaceResponse =
      zio.aws.iottwinmaker.model.CreateWorkspaceResponse(arn, creationDateTime)
    def arn: TwinMakerArn
    def creationDateTime: Timestamp
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceResponse
  ) extends zio.aws.iottwinmaker.model.CreateWorkspaceResponse.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceResponse
  ): zio.aws.iottwinmaker.model.CreateWorkspaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
