package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Value, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PropertyDefinitionRequest(
    configuration: Option[Map[Name, Value]] = None,
    dataType: Option[zio.aws.iottwinmaker.model.DataType] = None,
    defaultValue: Option[zio.aws.iottwinmaker.model.DataValue] = None,
    isExternalId: Option[Boolean] = None,
    isRequiredInEntity: Option[Boolean] = None,
    isStoredExternally: Option[Boolean] = None,
    isTimeSeries: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest = {
    import PropertyDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest
      .builder()
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> (Value.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.configuration)
      .optionallyWith(dataType.map(value => value.buildAwsValue()))(_.dataType)
      .optionallyWith(defaultValue.map(value => value.buildAwsValue()))(
        _.defaultValue
      )
      .optionallyWith(isExternalId.map(value => value: java.lang.Boolean))(
        _.isExternalId
      )
      .optionallyWith(
        isRequiredInEntity.map(value => value: java.lang.Boolean)
      )(_.isRequiredInEntity)
      .optionallyWith(
        isStoredExternally.map(value => value: java.lang.Boolean)
      )(_.isStoredExternally)
      .optionallyWith(isTimeSeries.map(value => value: java.lang.Boolean))(
        _.isTimeSeries
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyDefinitionRequest.wrap(buildAwsValue())
}
object PropertyDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyDefinitionRequest =
      zio.aws.iottwinmaker.model.PropertyDefinitionRequest(
        configuration.map(value => value),
        dataType.map(value => value.asEditable),
        defaultValue.map(value => value.asEditable),
        isExternalId.map(value => value),
        isRequiredInEntity.map(value => value),
        isStoredExternally.map(value => value),
        isTimeSeries.map(value => value)
      )
    def configuration: Option[Map[Name, Value]]
    def dataType: Option[zio.aws.iottwinmaker.model.DataType.ReadOnly]
    def defaultValue: Option[zio.aws.iottwinmaker.model.DataValue.ReadOnly]
    def isExternalId: Option[Boolean]
    def isRequiredInEntity: Option[Boolean]
    def isStoredExternally: Option[Boolean]
    def isTimeSeries: Option[Boolean]
    def getConfiguration: ZIO[Any, AwsError, Map[Name, Value]] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getDataType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataType.ReadOnly] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getDefaultValue
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getIsExternalId: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isExternalId", isExternalId)
    def getIsRequiredInEntity: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRequiredInEntity", isRequiredInEntity)
    def getIsStoredExternally: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isStoredExternally", isStoredExternally)
    def getIsTimeSeries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isTimeSeries", isTimeSeries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest
  ) extends zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly {
    override val configuration: Option[Map[Name, Value]] = scala
      .Option(impl.configuration())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives
              .Name(key) -> zio.aws.iottwinmaker.model.primitives.Value(value)
          })
          .toMap
      )
    override val dataType
        : Option[zio.aws.iottwinmaker.model.DataType.ReadOnly] = scala
      .Option(impl.dataType())
      .map(value => zio.aws.iottwinmaker.model.DataType.wrap(value))
    override val defaultValue
        : Option[zio.aws.iottwinmaker.model.DataValue.ReadOnly] = scala
      .Option(impl.defaultValue())
      .map(value => zio.aws.iottwinmaker.model.DataValue.wrap(value))
    override val isExternalId: Option[Boolean] =
      scala.Option(impl.isExternalId()).map(value => value: Boolean)
    override val isRequiredInEntity: Option[Boolean] =
      scala.Option(impl.isRequiredInEntity()).map(value => value: Boolean)
    override val isStoredExternally: Option[Boolean] =
      scala.Option(impl.isStoredExternally()).map(value => value: Boolean)
    override val isTimeSeries: Option[Boolean] =
      scala.Option(impl.isTimeSeries()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest
  ): zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
