package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.LambdaArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LambdaFunction(arn: LambdaArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.LambdaFunction = {
    import LambdaFunction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.LambdaFunction
      .builder()
      .arn(LambdaArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.LambdaFunction.ReadOnly =
    zio.aws.iottwinmaker.model.LambdaFunction.wrap(buildAwsValue())
}
object LambdaFunction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.LambdaFunction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.LambdaFunction =
      zio.aws.iottwinmaker.model.LambdaFunction(arn)
    def arn: LambdaArn
    def getArn: ZIO[Any, Nothing, LambdaArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.LambdaFunction
  ) extends zio.aws.iottwinmaker.model.LambdaFunction.ReadOnly {
    override val arn: LambdaArn =
      zio.aws.iottwinmaker.model.primitives.LambdaArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.LambdaFunction
  ): zio.aws.iottwinmaker.model.LambdaFunction.ReadOnly = new Wrapper(impl)
}
