package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Id, EntityId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteEntityRequest(
    entityId: EntityId,
    isRecursive: Option[Boolean] = None,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest = {
    import DeleteEntityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest
      .builder()
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .optionallyWith(isRecursive.map(value => value: java.lang.Boolean))(
        _.isRecursive
      )
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DeleteEntityRequest.ReadOnly =
    zio.aws.iottwinmaker.model.DeleteEntityRequest.wrap(buildAwsValue())
}
object DeleteEntityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DeleteEntityRequest =
      zio.aws.iottwinmaker.model.DeleteEntityRequest(
        entityId,
        isRecursive.map(value => value),
        workspaceId
      )
    def entityId: EntityId
    def isRecursive: Option[Boolean]
    def workspaceId: Id
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getIsRecursive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRecursive", isRecursive)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest
  ) extends zio.aws.iottwinmaker.model.DeleteEntityRequest.ReadOnly {
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
    override val isRecursive: Option[Boolean] =
      scala.Option(impl.isRecursive()).map(value => value: Boolean)
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest
  ): zio.aws.iottwinmaker.model.DeleteEntityRequest.ReadOnly = new Wrapper(impl)
}
