package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Id,
  Description,
  Timestamp,
  TwinMakerArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class WorkspaceSummary(
    arn: TwinMakerArn,
    creationDateTime: Timestamp,
    description: Option[Description] = None,
    updateDateTime: Timestamp,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.WorkspaceSummary = {
    import WorkspaceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.WorkspaceSummary
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.WorkspaceSummary.ReadOnly =
    zio.aws.iottwinmaker.model.WorkspaceSummary.wrap(buildAwsValue())
}
object WorkspaceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.WorkspaceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.WorkspaceSummary =
      zio.aws.iottwinmaker.model.WorkspaceSummary(
        arn,
        creationDateTime,
        description.map(value => value),
        updateDateTime,
        workspaceId
      )
    def arn: TwinMakerArn
    def creationDateTime: Timestamp
    def description: Option[Description]
    def updateDateTime: Timestamp
    def workspaceId: Id
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.WorkspaceSummary
  ) extends zio.aws.iottwinmaker.model.WorkspaceSummary.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.WorkspaceSummary
  ): zio.aws.iottwinmaker.model.WorkspaceSummary.ReadOnly = new Wrapper(impl)
}
