package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PropertyValue(
    timestamp: Timestamp,
    value: zio.aws.iottwinmaker.model.DataValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyValue = {
    import PropertyValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyValue
      .builder()
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyValue.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyValue.wrap(buildAwsValue())
}
object PropertyValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyValue =
      zio.aws.iottwinmaker.model.PropertyValue(timestamp, value.asEditable)
    def timestamp: Timestamp
    def value: zio.aws.iottwinmaker.model.DataValue.ReadOnly
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getValue
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyValue
  ) extends zio.aws.iottwinmaker.model.PropertyValue.ReadOnly {
    override val timestamp: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.timestamp())
    override val value: zio.aws.iottwinmaker.model.DataValue.ReadOnly =
      zio.aws.iottwinmaker.model.DataValue.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyValue
  ): zio.aws.iottwinmaker.model.PropertyValue.ReadOnly = new Wrapper(impl)
}
