package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait State {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.State
}
object State {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.State
  ): zio.aws.iottwinmaker.model.State = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.State.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.State.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.iottwinmaker.model.State.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.iottwinmaker.model.State.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.iottwinmaker.model.State.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.State.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion extends zio.aws.iottwinmaker.model.State {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.State =
      software.amazon.awssdk.services.iottwinmaker.model.State.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.iottwinmaker.model.State {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.State =
      software.amazon.awssdk.services.iottwinmaker.model.State.CREATING
  }
  case object UPDATING extends zio.aws.iottwinmaker.model.State {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.State =
      software.amazon.awssdk.services.iottwinmaker.model.State.UPDATING
  }
  case object DELETING extends zio.aws.iottwinmaker.model.State {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.State =
      software.amazon.awssdk.services.iottwinmaker.model.State.DELETING
  }
  case object ACTIVE extends zio.aws.iottwinmaker.model.State {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.State =
      software.amazon.awssdk.services.iottwinmaker.model.State.ACTIVE
  }
  case object ERROR extends zio.aws.iottwinmaker.model.State {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.State =
      software.amazon.awssdk.services.iottwinmaker.model.State.ERROR
  }
}
