package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  RoleArn,
  S3Location,
  TagValue,
  Description,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateWorkspaceRequest(
    description: Option[Description] = None,
    role: RoleArn,
    s3Location: S3Location,
    tags: Option[Map[TagKey, TagValue]] = None,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest = {
    import CreateWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .role(RoleArn.unwrap(role): java.lang.String)
      .s3Location(S3Location.unwrap(s3Location): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.CreateWorkspaceRequest.ReadOnly =
    zio.aws.iottwinmaker.model.CreateWorkspaceRequest.wrap(buildAwsValue())
}
object CreateWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateWorkspaceRequest =
      zio.aws.iottwinmaker.model.CreateWorkspaceRequest(
        description.map(value => value),
        role,
        s3Location,
        tags.map(value => value),
        workspaceId
      )
    def description: Option[Description]
    def role: RoleArn
    def s3Location: S3Location
    def tags: Option[Map[TagKey, TagValue]]
    def workspaceId: Id
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRole: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(role)
    def getS3Location: ZIO[Any, Nothing, S3Location] = ZIO.succeed(s3Location)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest
  ) extends zio.aws.iottwinmaker.model.CreateWorkspaceRequest.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val role: RoleArn =
      zio.aws.iottwinmaker.model.primitives.RoleArn(impl.role())
    override val s3Location: S3Location =
      zio.aws.iottwinmaker.model.primitives.S3Location(impl.s3Location())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.TagKey(
              key
            ) -> zio.aws.iottwinmaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest
  ): zio.aws.iottwinmaker.model.CreateWorkspaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
