package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.Type
  ): zio.aws.iottwinmaker.model.Type = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Type.RELATIONSHIP =>
      val r = RELATIONSHIP
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Type.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Type.LONG =>
      val r = LONG
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Type.BOOLEAN =>
      val r = BOOLEAN
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Type.INTEGER =>
      val r = INTEGER
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Type.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Type.LIST =>
      val r = LIST
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Type.MAP =>
      val r = MAP
      r
  }
  case object unknownToSdkVersion extends zio.aws.iottwinmaker.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Type =
      software.amazon.awssdk.services.iottwinmaker.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object RELATIONSHIP extends zio.aws.iottwinmaker.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Type =
      software.amazon.awssdk.services.iottwinmaker.model.Type.RELATIONSHIP
  }
  case object STRING extends zio.aws.iottwinmaker.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Type =
      software.amazon.awssdk.services.iottwinmaker.model.Type.STRING
  }
  case object LONG extends zio.aws.iottwinmaker.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Type =
      software.amazon.awssdk.services.iottwinmaker.model.Type.LONG
  }
  case object BOOLEAN extends zio.aws.iottwinmaker.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Type =
      software.amazon.awssdk.services.iottwinmaker.model.Type.BOOLEAN
  }
  case object INTEGER extends zio.aws.iottwinmaker.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Type =
      software.amazon.awssdk.services.iottwinmaker.model.Type.INTEGER
  }
  case object DOUBLE extends zio.aws.iottwinmaker.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Type =
      software.amazon.awssdk.services.iottwinmaker.model.Type.DOUBLE
  }
  case object LIST extends zio.aws.iottwinmaker.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Type =
      software.amazon.awssdk.services.iottwinmaker.model.Type.LIST
  }
  case object MAP extends zio.aws.iottwinmaker.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Type =
      software.amazon.awssdk.services.iottwinmaker.model.Type.MAP
  }
}
