package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Status(
    error: Option[zio.aws.iottwinmaker.model.ErrorDetails] = None,
    state: Option[zio.aws.iottwinmaker.model.State] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.Status = {
    import Status.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.Status
      .builder()
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.Status.ReadOnly =
    zio.aws.iottwinmaker.model.Status.wrap(buildAwsValue())
}
object Status {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.Status
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.Status =
      zio.aws.iottwinmaker.model
        .Status(error.map(value => value.asEditable), state.map(value => value))
    def error: Option[zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly]
    def state: Option[zio.aws.iottwinmaker.model.State]
    def getError
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
    def getState: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.State] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Status
  ) extends zio.aws.iottwinmaker.model.Status.ReadOnly {
    override val error
        : Option[zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly] = scala
      .Option(impl.error())
      .map(value => zio.aws.iottwinmaker.model.ErrorDetails.wrap(value))
    override val state: Option[zio.aws.iottwinmaker.model.State] = scala
      .Option(impl.state())
      .map(value => zio.aws.iottwinmaker.model.State.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Status
  ): zio.aws.iottwinmaker.model.Status.ReadOnly = new Wrapper(impl)
}
