package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  NextToken,
  Timestamp,
  EntityId,
  MaxResults,
  ComponentTypeId,
  Name,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetPropertyValueHistoryRequest(
    componentName: Option[Name] = None,
    componentTypeId: Option[ComponentTypeId] = None,
    endDateTime: Timestamp,
    entityId: Option[EntityId] = None,
    interpolation: Option[zio.aws.iottwinmaker.model.InterpolationParameters] =
      None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    orderByTime: Option[zio.aws.iottwinmaker.model.OrderByTime] = None,
    propertyFilters: Option[
      Iterable[zio.aws.iottwinmaker.model.PropertyFilter]
    ] = None,
    selectedProperties: Iterable[String],
    startDateTime: Timestamp,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest = {
    import GetPropertyValueHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest
      .builder()
      .optionallyWith(
        componentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.componentName)
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .endDateTime(Timestamp.unwrap(endDateTime): Instant)
      .optionallyWith(
        entityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(interpolation.map(value => value.buildAwsValue()))(
        _.interpolation
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(orderByTime.map(value => value.unwrap))(_.orderByTime)
      .optionallyWith(
        propertyFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.propertyFilters)
      .selectedProperties(selectedProperties.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .startDateTime(Timestamp.unwrap(startDateTime): Instant)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest
      .wrap(buildAwsValue())
}
object GetPropertyValueHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest =
      zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest(
        componentName.map(value => value),
        componentTypeId.map(value => value),
        endDateTime,
        entityId.map(value => value),
        interpolation.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        orderByTime.map(value => value),
        propertyFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        selectedProperties,
        startDateTime,
        workspaceId
      )
    def componentName: Option[Name]
    def componentTypeId: Option[ComponentTypeId]
    def endDateTime: Timestamp
    def entityId: Option[EntityId]
    def interpolation
        : Option[zio.aws.iottwinmaker.model.InterpolationParameters.ReadOnly]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def orderByTime: Option[zio.aws.iottwinmaker.model.OrderByTime]
    def propertyFilters
        : Option[List[zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly]]
    def selectedProperties: List[String]
    def startDateTime: Timestamp
    def workspaceId: Id
    def getComponentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getEndDateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDateTime)
    def getEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getInterpolation: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.InterpolationParameters.ReadOnly
    ] = AwsError.unwrapOptionField("interpolation", interpolation)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOrderByTime
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.OrderByTime] =
      AwsError.unwrapOptionField("orderByTime", orderByTime)
    def getPropertyFilters: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyFilters", propertyFilters)
    def getSelectedProperties: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(selectedProperties)
    def getStartDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(startDateTime)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest
  ) extends zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest.ReadOnly {
    override val componentName: Option[Name] = scala
      .Option(impl.componentName())
      .map(value => zio.aws.iottwinmaker.model.primitives.Name(value))
    override val componentTypeId: Option[ComponentTypeId] = scala
      .Option(impl.componentTypeId())
      .map(value =>
        zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
      )
    override val endDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.endDateTime())
    override val entityId: Option[EntityId] = scala
      .Option(impl.entityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityId(value))
    override val interpolation
        : Option[zio.aws.iottwinmaker.model.InterpolationParameters.ReadOnly] =
      scala
        .Option(impl.interpolation())
        .map(value =>
          zio.aws.iottwinmaker.model.InterpolationParameters.wrap(value)
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val orderByTime: Option[zio.aws.iottwinmaker.model.OrderByTime] =
      scala
        .Option(impl.orderByTime())
        .map(value => zio.aws.iottwinmaker.model.OrderByTime.wrap(value))
    override val propertyFilters
        : Option[List[zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly]] =
      scala
        .Option(impl.propertyFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.PropertyFilter.wrap(item)
          }.toList
        )
    override val selectedProperties: List[String] = impl
      .selectedProperties()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val startDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.startDateTime())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest
  ): zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
