package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Integer, Expression}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DataValue(
    booleanValue: Option[Boolean] = None,
    doubleValue: Option[Double] = None,
    expression: Option[Expression] = None,
    integerValue: Option[Integer] = None,
    listValue: Option[Iterable[zio.aws.iottwinmaker.model.DataValue]] = None,
    longValue: Option[Long] = None,
    mapValue: Option[Map[String, zio.aws.iottwinmaker.model.DataValue]] = None,
    relationshipValue: Option[zio.aws.iottwinmaker.model.RelationshipValue] =
      None,
    stringValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DataValue = {
    import DataValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DataValue
      .builder()
      .optionallyWith(booleanValue.map(value => value: java.lang.Boolean))(
        _.booleanValue
      )
      .optionallyWith(doubleValue.map(value => value: java.lang.Double))(
        _.doubleValue
      )
      .optionallyWith(
        expression.map(value => Expression.unwrap(value): java.lang.String)
      )(_.expression)
      .optionallyWith(
        integerValue.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.integerValue)
      .optionallyWith(
        listValue.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listValue)
      .optionallyWith(longValue.map(value => value: java.lang.Long))(
        _.longValue
      )
      .optionallyWith(
        mapValue.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.mapValue)
      .optionallyWith(relationshipValue.map(value => value.buildAwsValue()))(
        _.relationshipValue
      )
      .optionallyWith(stringValue.map(value => value: java.lang.String))(
        _.stringValue
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DataValue.ReadOnly =
    zio.aws.iottwinmaker.model.DataValue.wrap(buildAwsValue())
}
object DataValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DataValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DataValue =
      zio.aws.iottwinmaker.model.DataValue(
        booleanValue.map(value => value),
        doubleValue.map(value => value),
        expression.map(value => value),
        integerValue.map(value => value),
        listValue.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        longValue.map(value => value),
        mapValue.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        relationshipValue.map(value => value.asEditable),
        stringValue.map(value => value)
      )
    def booleanValue: Option[Boolean]
    def doubleValue: Option[Double]
    def expression: Option[Expression]
    def integerValue: Option[Integer]
    def listValue: Option[List[zio.aws.iottwinmaker.model.DataValue.ReadOnly]]
    def longValue: Option[Long]
    def mapValue
        : Option[Map[String, zio.aws.iottwinmaker.model.DataValue.ReadOnly]]
    def relationshipValue
        : Option[zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly]
    def stringValue: Option[String]
    def getBooleanValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
    def getDoubleValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getExpression: ZIO[Any, AwsError, Expression] =
      AwsError.unwrapOptionField("expression", expression)
    def getIntegerValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getListValue: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.DataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("listValue", listValue)
    def getLongValue: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("longValue", longValue)
    def getMapValue: ZIO[Any, AwsError, Map[
      String,
      zio.aws.iottwinmaker.model.DataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("mapValue", mapValue)
    def getRelationshipValue: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly
    ] = AwsError.unwrapOptionField("relationshipValue", relationshipValue)
    def getStringValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stringValue", stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataValue
  ) extends zio.aws.iottwinmaker.model.DataValue.ReadOnly {
    override val booleanValue: Option[Boolean] =
      scala.Option(impl.booleanValue()).map(value => value: Boolean)
    override val doubleValue: Option[Double] =
      scala.Option(impl.doubleValue()).map(value => value: Double)
    override val expression: Option[Expression] = scala
      .Option(impl.expression())
      .map(value => zio.aws.iottwinmaker.model.primitives.Expression(value))
    override val integerValue: Option[Integer] = scala
      .Option(impl.integerValue())
      .map(value => zio.aws.iottwinmaker.model.primitives.Integer(value))
    override val listValue
        : Option[List[zio.aws.iottwinmaker.model.DataValue.ReadOnly]] = scala
      .Option(impl.listValue())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.DataValue.wrap(item)
        }.toList
      )
    override val longValue: Option[Long] =
      scala.Option(impl.longValue()).map(value => value: Long)
    override val mapValue
        : Option[Map[String, zio.aws.iottwinmaker.model.DataValue.ReadOnly]] =
      scala
        .Option(impl.mapValue())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.iottwinmaker.model.DataValue.wrap(value)
            })
            .toMap
        )
    override val relationshipValue
        : Option[zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly] = scala
      .Option(impl.relationshipValue())
      .map(value => zio.aws.iottwinmaker.model.RelationshipValue.wrap(value))
    override val stringValue: Option[String] =
      scala.Option(impl.stringValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataValue
  ): zio.aws.iottwinmaker.model.DataValue.ReadOnly = new Wrapper(impl)
}
