package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  SceneCapability,
  Timestamp,
  S3Url,
  Description,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetSceneResponse(
    arn: TwinMakerArn,
    capabilities: Option[Iterable[SceneCapability]] = None,
    contentLocation: S3Url,
    creationDateTime: Timestamp,
    description: Option[Description] = None,
    sceneId: Id,
    updateDateTime: Timestamp,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse = {
    import GetSceneResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            SceneCapability.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capabilities)
      .contentLocation(S3Url.unwrap(contentLocation): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetSceneResponse.wrap(buildAwsValue())
}
object GetSceneResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetSceneResponse =
      zio.aws.iottwinmaker.model.GetSceneResponse(
        arn,
        capabilities.map(value => value),
        contentLocation,
        creationDateTime,
        description.map(value => value),
        sceneId,
        updateDateTime,
        workspaceId
      )
    def arn: TwinMakerArn
    def capabilities: Option[List[SceneCapability]]
    def contentLocation: S3Url
    def creationDateTime: Timestamp
    def description: Option[Description]
    def sceneId: Id
    def updateDateTime: Timestamp
    def workspaceId: Id
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCapabilities: ZIO[Any, AwsError, List[SceneCapability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getContentLocation: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(contentLocation)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
  ) extends zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val capabilities: Option[List[SceneCapability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.primitives.SceneCapability(item)
        }.toList
      )
    override val contentLocation: S3Url =
      zio.aws.iottwinmaker.model.primitives.S3Url(impl.contentLocation())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
  ): zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly = new Wrapper(impl)
}
