package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PropertyRequest(
    definition: Option[zio.aws.iottwinmaker.model.PropertyDefinitionRequest] =
      None,
    updateType: Option[zio.aws.iottwinmaker.model.PropertyUpdateType] = None,
    value: Option[zio.aws.iottwinmaker.model.DataValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest = {
    import PropertyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest
      .builder()
      .optionallyWith(definition.map(value => value.buildAwsValue()))(
        _.definition
      )
      .optionallyWith(updateType.map(value => value.unwrap))(_.updateType)
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyRequest.wrap(buildAwsValue())
}
object PropertyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyRequest =
      zio.aws.iottwinmaker.model.PropertyRequest(
        definition.map(value => value.asEditable),
        updateType.map(value => value),
        value.map(value => value.asEditable)
      )
    def definition
        : Option[zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly]
    def updateType: Option[zio.aws.iottwinmaker.model.PropertyUpdateType]
    def value: Option[zio.aws.iottwinmaker.model.DataValue.ReadOnly]
    def getDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly
    ] = AwsError.unwrapOptionField("definition", definition)
    def getUpdateType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.PropertyUpdateType] =
      AwsError.unwrapOptionField("updateType", updateType)
    def getValue
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest
  ) extends zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly {
    override val definition: Option[
      zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly
    ] = scala
      .Option(impl.definition())
      .map(value =>
        zio.aws.iottwinmaker.model.PropertyDefinitionRequest.wrap(value)
      )
    override val updateType
        : Option[zio.aws.iottwinmaker.model.PropertyUpdateType] = scala
      .Option(impl.updateType())
      .map(value => zio.aws.iottwinmaker.model.PropertyUpdateType.wrap(value))
    override val value: Option[zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      scala
        .Option(impl.value())
        .map(value => zio.aws.iottwinmaker.model.DataValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest
  ): zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly = new Wrapper(impl)
}
