package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  TagValue,
  ParentEntityId,
  Description,
  EntityId,
  Name,
  EntityName,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEntityRequest(
    components: Option[Map[Name, zio.aws.iottwinmaker.model.ComponentRequest]] =
      None,
    description: Option[Description] = None,
    entityId: Option[EntityId] = None,
    entityName: EntityName,
    parentEntityId: Option[ParentEntityId] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest = {
    import CreateEntityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest
      .builder()
      .optionallyWith(
        components.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.components)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        entityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.entityId)
      .entityName(EntityName.unwrap(entityName): java.lang.String)
      .optionallyWith(
        parentEntityId.map(value =>
          ParentEntityId.unwrap(value): java.lang.String
        )
      )(_.parentEntityId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.CreateEntityRequest.ReadOnly =
    zio.aws.iottwinmaker.model.CreateEntityRequest.wrap(buildAwsValue())
}
object CreateEntityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateEntityRequest =
      zio.aws.iottwinmaker.model.CreateEntityRequest(
        components.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        description.map(value => value),
        entityId.map(value => value),
        entityName,
        parentEntityId.map(value => value),
        tags.map(value => value),
        workspaceId
      )
    def components: Option[
      Map[Name, zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly]
    ]
    def description: Option[Description]
    def entityId: Option[EntityId]
    def entityName: EntityName
    def parentEntityId: Option[ParentEntityId]
    def tags: Option[Map[TagKey, TagValue]]
    def workspaceId: Id
    def getComponents: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("components", components)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getEntityName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(entityName)
    def getParentEntityId: ZIO[Any, AwsError, ParentEntityId] =
      AwsError.unwrapOptionField("parentEntityId", parentEntityId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest
  ) extends zio.aws.iottwinmaker.model.CreateEntityRequest.ReadOnly {
    override val components: Option[
      Map[Name, zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly]
    ] = scala
      .Option(impl.components())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.ComponentRequest.wrap(value)
          })
          .toMap
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val entityId: Option[EntityId] = scala
      .Option(impl.entityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityId(value))
    override val entityName: EntityName =
      zio.aws.iottwinmaker.model.primitives.EntityName(impl.entityName())
    override val parentEntityId: Option[ParentEntityId] = scala
      .Option(impl.parentEntityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.ParentEntityId(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.TagKey(
              key
            ) -> zio.aws.iottwinmaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest
  ): zio.aws.iottwinmaker.model.CreateEntityRequest.ReadOnly = new Wrapper(impl)
}
