package zio.aws.iotthingsgraph
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.iotthingsgraph.{
  IoTThingsGraphAsyncClientBuilder,
  IoTThingsGraphAsyncClient
}
import zio.aws.core.AwsServiceBase
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Scope, ZIO, ZLayer}
import scala.jdk.CollectionConverters.*
trait IoTThingsGraph extends AspectSupport[IoTThingsGraph] {
  val api: IoTThingsGraphAsyncClient
}
object IoTThingsGraph {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IoTThingsGraph] = customized(
    identity
  )
  def customized(
      customization: IoTThingsGraphAsyncClientBuilder => IoTThingsGraphAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IoTThingsGraph] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IoTThingsGraphAsyncClientBuilder => IoTThingsGraphAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, IoTThingsGraph] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IoTThingsGraphAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IoTThingsGraphAsyncClient, IoTThingsGraphAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      IoTThingsGraphAsyncClient,
      IoTThingsGraphAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IoTThingsGraphImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IoTThingsGraphImpl[R](
      override val api: IoTThingsGraphAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IoTThingsGraph
      with AwsServiceBase[R] {
    override val serviceName: String = "IoTThingsGraph"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IoTThingsGraphImpl[R1] = new IoTThingsGraphImpl(api, newAspect, r)
  }
}
