package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotthingsgraph.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.Tag.ReadOnly =
    zio.aws.iotthingsgraph.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.Tag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.Tag =
      zio.aws.iotthingsgraph.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.Tag
  ) extends zio.aws.iotthingsgraph.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.iotthingsgraph.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.iotthingsgraph.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.Tag
  ): zio.aws.iotthingsgraph.model.Tag.ReadOnly = new Wrapper(impl)
}
