package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{ThingName, ThingArn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Thing(
    thingArn: Optional[ThingArn] = Optional.Absent,
    thingName: Optional[ThingName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.Thing = {
    import Thing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.Thing
      .builder()
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.Thing.ReadOnly =
    zio.aws.iotthingsgraph.model.Thing.wrap(buildAwsValue())
}
object Thing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.Thing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.Thing =
      zio.aws.iotthingsgraph.model
        .Thing(thingArn.map(value => value), thingName.map(value => value))
    def thingArn: Optional[ThingArn]
    def thingName: Optional[ThingName]
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.Thing
  ) extends zio.aws.iotthingsgraph.model.Thing.ReadOnly {
    override val thingArn: Optional[ThingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.ThingArn(value))
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value => zio.aws.iotthingsgraph.model.primitives.ThingName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.Thing
  ): zio.aws.iotthingsgraph.model.Thing.ReadOnly = new Wrapper(impl)
}
