package zio.aws.iotthingsgraph.model
import scala.jdk.CollectionConverters.*
sealed trait FlowExecutionEventType {
  def unwrap: software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType
}
object FlowExecutionEventType {
  def wrap(
      value: software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType
  ): zio.aws.iotthingsgraph.model.FlowExecutionEventType = value match {
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.EXECUTION_STARTED =>
      val r = EXECUTION_STARTED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.EXECUTION_FAILED =>
      val r = EXECUTION_FAILED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.EXECUTION_ABORTED =>
      val r = EXECUTION_ABORTED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.EXECUTION_SUCCEEDED =>
      val r = EXECUTION_SUCCEEDED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.STEP_STARTED =>
      val r = STEP_STARTED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.STEP_FAILED =>
      val r = STEP_FAILED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.STEP_SUCCEEDED =>
      val r = STEP_SUCCEEDED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.ACTIVITY_SCHEDULED =>
      val r = ACTIVITY_SCHEDULED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.ACTIVITY_STARTED =>
      val r = ACTIVITY_STARTED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.ACTIVITY_FAILED =>
      val r = ACTIVITY_FAILED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.ACTIVITY_SUCCEEDED =>
      val r = ACTIVITY_SUCCEEDED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.START_FLOW_EXECUTION_TASK =>
      val r = START_FLOW_EXECUTION_TASK
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.SCHEDULE_NEXT_READY_STEPS_TASK =>
      val r = SCHEDULE_NEXT_READY_STEPS_TASK
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.THING_ACTION_TASK =>
      val r = THING_ACTION_TASK
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.THING_ACTION_TASK_FAILED =>
      val r = THING_ACTION_TASK_FAILED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.THING_ACTION_TASK_SUCCEEDED =>
      val r = THING_ACTION_TASK_SUCCEEDED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.ACKNOWLEDGE_TASK_MESSAGE =>
      val r = ACKNOWLEDGE_TASK_MESSAGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object EXECUTION_STARTED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.EXECUTION_STARTED
  }
  case object EXECUTION_FAILED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.EXECUTION_FAILED
  }
  case object EXECUTION_ABORTED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.EXECUTION_ABORTED
  }
  case object EXECUTION_SUCCEEDED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.EXECUTION_SUCCEEDED
  }
  case object STEP_STARTED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.STEP_STARTED
  }
  case object STEP_FAILED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.STEP_FAILED
  }
  case object STEP_SUCCEEDED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.STEP_SUCCEEDED
  }
  case object ACTIVITY_SCHEDULED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.ACTIVITY_SCHEDULED
  }
  case object ACTIVITY_STARTED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.ACTIVITY_STARTED
  }
  case object ACTIVITY_FAILED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.ACTIVITY_FAILED
  }
  case object ACTIVITY_SUCCEEDED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.ACTIVITY_SUCCEEDED
  }
  case object START_FLOW_EXECUTION_TASK
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.START_FLOW_EXECUTION_TASK
  }
  case object SCHEDULE_NEXT_READY_STEPS_TASK
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.SCHEDULE_NEXT_READY_STEPS_TASK
  }
  case object THING_ACTION_TASK
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.THING_ACTION_TASK
  }
  case object THING_ACTION_TASK_FAILED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.THING_ACTION_TASK_FAILED
  }
  case object THING_ACTION_TASK_SUCCEEDED
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.THING_ACTION_TASK_SUCCEEDED
  }
  case object ACKNOWLEDGE_TASK_MESSAGE
      extends zio.aws.iotthingsgraph.model.FlowExecutionEventType {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType =
      software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType.ACKNOWLEDGE_TASK_MESSAGE
  }
}
