package zio.aws.iotthingsgraph.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.iotthingsgraph.model.primitives.{
  Urn,
  Timestamp,
  GreengrassGroupVersionId,
  Arn,
  GroupName,
  GreengrassGroupId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class SystemInstanceSummary(
    id: Optional[Urn] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    status: Optional[
      zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus
    ] = Optional.Absent,
    target: Optional[zio.aws.iotthingsgraph.model.DeploymentTarget] =
      Optional.Absent,
    greengrassGroupName: Optional[GroupName] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    greengrassGroupId: Optional[GreengrassGroupId] = Optional.Absent,
    greengrassGroupVersionId: Optional[GreengrassGroupVersionId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary = {
    import SystemInstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary
      .builder()
      .optionallyWith(id.map(value => Urn.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(target.map(value => value.unwrap))(_.target)
      .optionallyWith(
        greengrassGroupName.map(value =>
          GroupName.unwrap(value): java.lang.String
        )
      )(_.greengrassGroupName)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        greengrassGroupId.map(value =>
          GreengrassGroupId.unwrap(value): java.lang.String
        )
      )(_.greengrassGroupId)
      .optionallyWith(
        greengrassGroupVersionId.map(value =>
          GreengrassGroupVersionId.unwrap(value): java.lang.String
        )
      )(_.greengrassGroupVersionId)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly =
    zio.aws.iotthingsgraph.model.SystemInstanceSummary.wrap(buildAwsValue())
}
object SystemInstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SystemInstanceSummary =
      zio.aws.iotthingsgraph.model.SystemInstanceSummary(
        id.map(value => value),
        arn.map(value => value),
        status.map(value => value),
        target.map(value => value),
        greengrassGroupName.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        greengrassGroupId.map(value => value),
        greengrassGroupVersionId.map(value => value)
      )
    def id: Optional[Urn]
    def arn: Optional[Arn]
    def status
        : Optional[zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus]
    def target: Optional[zio.aws.iotthingsgraph.model.DeploymentTarget]
    def greengrassGroupName: Optional[GroupName]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def greengrassGroupId: Optional[GreengrassGroupId]
    def greengrassGroupVersionId: Optional[GreengrassGroupVersionId]
    def getId: ZIO[Any, AwsError, Urn] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getTarget
        : ZIO[Any, AwsError, zio.aws.iotthingsgraph.model.DeploymentTarget] =
      AwsError.unwrapOptionField("target", target)
    def getGreengrassGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("greengrassGroupName", greengrassGroupName)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getGreengrassGroupId: ZIO[Any, AwsError, GreengrassGroupId] =
      AwsError.unwrapOptionField("greengrassGroupId", greengrassGroupId)
    def getGreengrassGroupVersionId
        : ZIO[Any, AwsError, GreengrassGroupVersionId] = AwsError
      .unwrapOptionField("greengrassGroupVersionId", greengrassGroupVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary
  ) extends zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly {
    override val id: Optional[Urn] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val status: Optional[
      zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus.wrap(value)
      )
    override val target
        : Optional[zio.aws.iotthingsgraph.model.DeploymentTarget] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value => zio.aws.iotthingsgraph.model.DeploymentTarget.wrap(value))
    override val greengrassGroupName: Optional[GroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greengrassGroupName())
        .map(value => zio.aws.iotthingsgraph.model.primitives.GroupName(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
    override val greengrassGroupId: Optional[GreengrassGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greengrassGroupId())
        .map(value =>
          zio.aws.iotthingsgraph.model.primitives.GreengrassGroupId(value)
        )
    override val greengrassGroupVersionId: Optional[GreengrassGroupVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greengrassGroupVersionId())
        .map(value =>
          zio.aws.iotthingsgraph.model.primitives
            .GreengrassGroupVersionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary
  ): zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly = new Wrapper(
    impl
  )
}
