package zio.aws.iotthingsgraph.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.iotthingsgraph.model.primitives.{Timestamp, Arn, Urn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EntityDescription(
    id: Optional[Urn] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    `type`: Optional[zio.aws.iotthingsgraph.model.EntityType] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    definition: Optional[zio.aws.iotthingsgraph.model.DefinitionDocument] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription = {
    import EntityDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription
      .builder()
      .optionallyWith(id.map(value => Urn.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(definition.map(value => value.buildAwsValue()))(
        _.definition
      )
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly =
    zio.aws.iotthingsgraph.model.EntityDescription.wrap(buildAwsValue())
}
object EntityDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.EntityDescription =
      zio.aws.iotthingsgraph.model.EntityDescription(
        id.map(value => value),
        arn.map(value => value),
        `type`.map(value => value),
        createdAt.map(value => value),
        definition.map(value => value.asEditable)
      )
    def id: Optional[Urn]
    def arn: Optional[Arn]
    def `type`: Optional[zio.aws.iotthingsgraph.model.EntityType]
    def createdAt: Optional[Timestamp]
    def definition
        : Optional[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly]
    def getId: ZIO[Any, AwsError, Urn] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.iotthingsgraph.model.EntityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = AwsError.unwrapOptionField("definition", definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription
  ) extends zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly {
    override val id: Optional[Urn] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val `type`: Optional[zio.aws.iotthingsgraph.model.EntityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.iotthingsgraph.model.EntityType.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
    override val definition
        : Optional[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definition())
        .map(value =>
          zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription
  ): zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly = new Wrapper(impl)
}
