package zio.aws.iotthingsgraph.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.iotthingsgraph.model.primitives.{Timestamp, Version, Arn, Urn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class FlowTemplateSummary(
    id: Optional[Urn] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    revisionNumber: Optional[Version] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateSummary = {
    import FlowTemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateSummary
      .builder()
      .optionallyWith(id.map(value => Urn.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        revisionNumber.map(value => Version.unwrap(value): java.lang.Long)
      )(_.revisionNumber)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly =
    zio.aws.iotthingsgraph.model.FlowTemplateSummary.wrap(buildAwsValue())
}
object FlowTemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.FlowTemplateSummary =
      zio.aws.iotthingsgraph.model.FlowTemplateSummary(
        id.map(value => value),
        arn.map(value => value),
        revisionNumber.map(value => value),
        createdAt.map(value => value)
      )
    def id: Optional[Urn]
    def arn: Optional[Arn]
    def revisionNumber: Optional[Version]
    def createdAt: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, Urn] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getRevisionNumber: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("revisionNumber", revisionNumber)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateSummary
  ) extends zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly {
    override val id: Optional[Urn] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val revisionNumber: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionNumber())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateSummary
  ): zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly = new Wrapper(
    impl
  )
}
