package zio.aws.iotthingsgraph.model
import scala.jdk.CollectionConverters.*
sealed trait UploadStatus {
  def unwrap: software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus
}
object UploadStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus
  ): zio.aws.iotthingsgraph.model.UploadStatus = value match {
    case software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotthingsgraph.model.UploadStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.iotthingsgraph.model.UploadStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.iotthingsgraph.model.UploadStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.iotthingsgraph.model.UploadStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus =
      software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus.FAILED
  }
}
