package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SearchThingsResponse(
    things: Optional[Iterable[zio.aws.iotthingsgraph.model.Thing]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse = {
    import SearchThingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse
      .builder()
      .optionallyWith(
        things.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.things)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SearchThingsResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.SearchThingsResponse.wrap(buildAwsValue())
}
object SearchThingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SearchThingsResponse =
      zio.aws.iotthingsgraph.model.SearchThingsResponse(
        things.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def things: Optional[List[zio.aws.iotthingsgraph.model.Thing.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getThings: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.Thing.ReadOnly
    ]] = AwsError.unwrapOptionField("things", things)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse
  ) extends zio.aws.iotthingsgraph.model.SearchThingsResponse.ReadOnly {
    override val things
        : Optional[List[zio.aws.iotthingsgraph.model.Thing.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.things())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotthingsgraph.model.Thing.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse
  ): zio.aws.iotthingsgraph.model.SearchThingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
