package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotthingsgraph.model.primitives.UploadId
import scala.jdk.CollectionConverters.*
final case class GetUploadStatusRequest(uploadId: UploadId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest = {
    import GetUploadStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest
      .builder()
      .uploadId(UploadId.unwrap(uploadId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.GetUploadStatusRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.GetUploadStatusRequest.wrap(buildAwsValue())
}
object GetUploadStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetUploadStatusRequest =
      zio.aws.iotthingsgraph.model.GetUploadStatusRequest(uploadId)
    def uploadId: UploadId
    def getUploadId: ZIO[Any, Nothing, UploadId] = ZIO.succeed(uploadId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest
  ) extends zio.aws.iotthingsgraph.model.GetUploadStatusRequest.ReadOnly {
    override val uploadId: UploadId =
      zio.aws.iotthingsgraph.model.primitives.UploadId(impl.uploadId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest
  ): zio.aws.iotthingsgraph.model.GetUploadStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
