package zio.aws.iotthingsgraph.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.iotthingsgraph.model.primitives.{
  NextToken,
  Urn,
  Timestamp,
  MaxResults,
  FlowExecutionId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchFlowExecutionsRequest(
    systemInstanceId: Urn,
    flowExecutionId: Optional[FlowExecutionId] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest = {
    import SearchFlowExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest
      .builder()
      .systemInstanceId(Urn.unwrap(systemInstanceId): java.lang.String)
      .optionallyWith(
        flowExecutionId.map(value =>
          FlowExecutionId.unwrap(value): java.lang.String
        )
      )(_.flowExecutionId)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.SearchFlowExecutionsRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.SearchFlowExecutionsRequest
      .wrap(buildAwsValue())
}
object SearchFlowExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SearchFlowExecutionsRequest =
      zio.aws.iotthingsgraph.model.SearchFlowExecutionsRequest(
        systemInstanceId,
        flowExecutionId.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def systemInstanceId: Urn
    def flowExecutionId: Optional[FlowExecutionId]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSystemInstanceId: ZIO[Any, Nothing, Urn] =
      ZIO.succeed(systemInstanceId)
    def getFlowExecutionId: ZIO[Any, AwsError, FlowExecutionId] =
      AwsError.unwrapOptionField("flowExecutionId", flowExecutionId)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest
  ) extends zio.aws.iotthingsgraph.model.SearchFlowExecutionsRequest.ReadOnly {
    override val systemInstanceId: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.systemInstanceId())
    override val flowExecutionId: Optional[FlowExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowExecutionId())
        .map(value =>
          zio.aws.iotthingsgraph.model.primitives.FlowExecutionId(value)
        )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest
  ): zio.aws.iotthingsgraph.model.SearchFlowExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
