package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSystemInstanceResponse(
    description: Optional[
      zio.aws.iotthingsgraph.model.SystemInstanceDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse = {
    import GetSystemInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse
      .builder()
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.wrap(buildAwsValue())
}
object GetSystemInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetSystemInstanceResponse =
      zio.aws.iotthingsgraph.model
        .GetSystemInstanceResponse(description.map(value => value.asEditable))
    def description: Optional[
      zio.aws.iotthingsgraph.model.SystemInstanceDescription.ReadOnly
    ]
    def getDescription: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemInstanceDescription.ReadOnly
    ] = AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse
  ) extends zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly {
    override val description: Optional[
      zio.aws.iotthingsgraph.model.SystemInstanceDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iotthingsgraph.model.SystemInstanceDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse
  ): zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
