package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetFlowTemplateRevisionsResponse(
    summaries: Optional[
      Iterable[zio.aws.iotthingsgraph.model.FlowTemplateSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse = {
    import GetFlowTemplateRevisionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse
      .wrap(buildAwsValue())
}
object GetFlowTemplateRevisionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse =
      zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries: Optional[
      List[zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse
  ) extends zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse.ReadOnly {
    override val summaries: Optional[
      List[zio.aws.iotthingsgraph.model.FlowTemplateSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotthingsgraph.model.FlowTemplateSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse
  ): zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsResponse.ReadOnly =
    new Wrapper(impl)
}
