package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.Version
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSystemTemplateRequest(
    definition: zio.aws.iotthingsgraph.model.DefinitionDocument,
    compatibleNamespaceVersion: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest = {
    import CreateSystemTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest
      .builder()
      .definition(definition.buildAwsValue())
      .optionallyWith(
        compatibleNamespaceVersion.map(value =>
          Version.unwrap(value): java.lang.Long
        )
      )(_.compatibleNamespaceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.CreateSystemTemplateRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.CreateSystemTemplateRequest
      .wrap(buildAwsValue())
}
object CreateSystemTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.CreateSystemTemplateRequest =
      zio.aws.iotthingsgraph.model.CreateSystemTemplateRequest(
        definition.asEditable,
        compatibleNamespaceVersion.map(value => value)
      )
    def definition: zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    def compatibleNamespaceVersion: Optional[Version]
    def getDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = ZIO.succeed(definition)
    def getCompatibleNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField(
        "compatibleNamespaceVersion",
        compatibleNamespaceVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest
  ) extends zio.aws.iotthingsgraph.model.CreateSystemTemplateRequest.ReadOnly {
    override val definition
        : zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly =
      zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(impl.definition())
    override val compatibleNamespaceVersion: Optional[Version] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compatibleNamespaceVersion())
        .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest
  ): zio.aws.iotthingsgraph.model.CreateSystemTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
