package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.EntityFilterValue
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EntityFilter(
    name: Optional[zio.aws.iotthingsgraph.model.EntityFilterName] =
      Optional.Absent,
    value: Optional[Iterable[EntityFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.EntityFilter = {
    import EntityFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.EntityFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value =>
          value.map { item =>
            EntityFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.EntityFilter.ReadOnly =
    zio.aws.iotthingsgraph.model.EntityFilter.wrap(buildAwsValue())
}
object EntityFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.EntityFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.EntityFilter =
      zio.aws.iotthingsgraph.model
        .EntityFilter(name.map(value => value), value.map(value => value))
    def name: Optional[zio.aws.iotthingsgraph.model.EntityFilterName]
    def value: Optional[List[EntityFilterValue]]
    def getName
        : ZIO[Any, AwsError, zio.aws.iotthingsgraph.model.EntityFilterName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, List[EntityFilterValue]] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.EntityFilter
  ) extends zio.aws.iotthingsgraph.model.EntityFilter.ReadOnly {
    override val name: Optional[zio.aws.iotthingsgraph.model.EntityFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.iotthingsgraph.model.EntityFilterName.wrap(value))
    override val value: Optional[List[EntityFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotthingsgraph.model.primitives.EntityFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.EntityFilter
  ): zio.aws.iotthingsgraph.model.EntityFilter.ReadOnly = new Wrapper(impl)
}
