package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{NamespaceName, Arn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteNamespaceResponse(
    namespaceArn: Optional[Arn] = Optional.Absent,
    namespaceName: Optional[NamespaceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse = {
    import DeleteNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse
      .builder()
      .optionallyWith(
        namespaceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.namespaceArn)
      .optionallyWith(
        namespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.namespaceName)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.DeleteNamespaceResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.DeleteNamespaceResponse.wrap(buildAwsValue())
}
object DeleteNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.DeleteNamespaceResponse =
      zio.aws.iotthingsgraph.model.DeleteNamespaceResponse(
        namespaceArn.map(value => value),
        namespaceName.map(value => value)
      )
    def namespaceArn: Optional[Arn]
    def namespaceName: Optional[NamespaceName]
    def getNamespaceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse
  ) extends zio.aws.iotthingsgraph.model.DeleteNamespaceResponse.ReadOnly {
    override val namespaceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceArn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val namespaceName: Optional[NamespaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.NamespaceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse
  ): zio.aws.iotthingsgraph.model.DeleteNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
