package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.Version
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SystemTemplateDescription(
    summary: Optional[zio.aws.iotthingsgraph.model.SystemTemplateSummary] =
      Optional.Absent,
    definition: Optional[zio.aws.iotthingsgraph.model.DefinitionDocument] =
      Optional.Absent,
    validatedNamespaceVersion: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateDescription = {
    import SystemTemplateDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateDescription
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .optionallyWith(definition.map(value => value.buildAwsValue()))(
        _.definition
      )
      .optionallyWith(
        validatedNamespaceVersion.map(value =>
          Version.unwrap(value): java.lang.Long
        )
      )(_.validatedNamespaceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.SystemTemplateDescription.ReadOnly =
    zio.aws.iotthingsgraph.model.SystemTemplateDescription.wrap(buildAwsValue())
}
object SystemTemplateDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SystemTemplateDescription =
      zio.aws.iotthingsgraph.model.SystemTemplateDescription(
        summary.map(value => value.asEditable),
        definition.map(value => value.asEditable),
        validatedNamespaceVersion.map(value => value)
      )
    def summary
        : Optional[zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly]
    def definition
        : Optional[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly]
    def validatedNamespaceVersion: Optional[Version]
    def getSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summary)
    def getDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = AwsError.unwrapOptionField("definition", definition)
    def getValidatedNamespaceVersion: ZIO[Any, AwsError, Version] = AwsError
      .unwrapOptionField("validatedNamespaceVersion", validatedNamespaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateDescription
  ) extends zio.aws.iotthingsgraph.model.SystemTemplateDescription.ReadOnly {
    override val summary: Optional[
      zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value =>
        zio.aws.iotthingsgraph.model.SystemTemplateSummary.wrap(value)
      )
    override val definition
        : Optional[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definition())
        .map(value =>
          zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(value)
        )
    override val validatedNamespaceVersion: Optional[Version] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validatedNamespaceVersion())
        .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateDescription
  ): zio.aws.iotthingsgraph.model.SystemTemplateDescription.ReadOnly =
    new Wrapper(impl)
}
