package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSystemTemplateResponse(
    summary: Optional[zio.aws.iotthingsgraph.model.SystemTemplateSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse = {
    import UpdateSystemTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse
      .wrap(buildAwsValue())
}
object UpdateSystemTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse =
      zio.aws.iotthingsgraph.model
        .UpdateSystemTemplateResponse(summary.map(value => value.asEditable))
    def summary
        : Optional[zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly]
    def getSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse
  ) extends zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse.ReadOnly {
    override val summary: Optional[
      zio.aws.iotthingsgraph.model.SystemTemplateSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value =>
        zio.aws.iotthingsgraph.model.SystemTemplateSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse
  ): zio.aws.iotthingsgraph.model.UpdateSystemTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
