package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.NamespaceName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeNamespaceRequest(
    namespaceName: Optional[NamespaceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest = {
    import DescribeNamespaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest
      .builder()
      .optionallyWith(
        namespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.namespaceName)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.DescribeNamespaceRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.DescribeNamespaceRequest.wrap(buildAwsValue())
}
object DescribeNamespaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.DescribeNamespaceRequest =
      zio.aws.iotthingsgraph.model
        .DescribeNamespaceRequest(namespaceName.map(value => value))
    def namespaceName: Optional[NamespaceName]
    def getNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest
  ) extends zio.aws.iotthingsgraph.model.DescribeNamespaceRequest.ReadOnly {
    override val namespaceName: Optional[NamespaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.NamespaceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest
  ): zio.aws.iotthingsgraph.model.DescribeNamespaceRequest.ReadOnly =
    new Wrapper(impl)
}
