package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.Urn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeploySystemInstanceRequest(
    id: Optional[Urn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest = {
    import DeploySystemInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest
      .builder()
      .optionallyWith(id.map(value => Urn.unwrap(value): java.lang.String))(
        _.id
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.DeploySystemInstanceRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.DeploySystemInstanceRequest
      .wrap(buildAwsValue())
}
object DeploySystemInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.DeploySystemInstanceRequest =
      zio.aws.iotthingsgraph.model
        .DeploySystemInstanceRequest(id.map(value => value))
    def id: Optional[Urn]
    def getId: ZIO[Any, AwsError, Urn] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest
  ) extends zio.aws.iotthingsgraph.model.DeploySystemInstanceRequest.ReadOnly {
    override val id: Optional[Urn] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest
  ): zio.aws.iotthingsgraph.model.DeploySystemInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
