package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.SystemInstanceFilterValue
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SystemInstanceFilter(
    name: Optional[zio.aws.iotthingsgraph.model.SystemInstanceFilterName] =
      Optional.Absent,
    value: Optional[Iterable[SystemInstanceFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilter = {
    import SystemInstanceFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value =>
          value.map { item =>
            SystemInstanceFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SystemInstanceFilter.ReadOnly =
    zio.aws.iotthingsgraph.model.SystemInstanceFilter.wrap(buildAwsValue())
}
object SystemInstanceFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SystemInstanceFilter =
      zio.aws.iotthingsgraph.model.SystemInstanceFilter(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.iotthingsgraph.model.SystemInstanceFilterName]
    def value: Optional[List[SystemInstanceFilterValue]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemInstanceFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, List[SystemInstanceFilterValue]] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilter
  ) extends zio.aws.iotthingsgraph.model.SystemInstanceFilter.ReadOnly {
    override val name
        : Optional[zio.aws.iotthingsgraph.model.SystemInstanceFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.iotthingsgraph.model.SystemInstanceFilterName.wrap(value)
        )
    override val value: Optional[List[SystemInstanceFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotthingsgraph.model.primitives
              .SystemInstanceFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilter
  ): zio.aws.iotthingsgraph.model.SystemInstanceFilter.ReadOnly = new Wrapper(
    impl
  )
}
