package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Version, Urn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSystemTemplateRequest(
    id: Urn,
    revisionNumber: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest = {
    import GetSystemTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest
      .builder()
      .id(Urn.unwrap(id): java.lang.String)
      .optionallyWith(
        revisionNumber.map(value => Version.unwrap(value): java.lang.Long)
      )(_.revisionNumber)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetSystemTemplateRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.GetSystemTemplateRequest.wrap(buildAwsValue())
}
object GetSystemTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetSystemTemplateRequest =
      zio.aws.iotthingsgraph.model
        .GetSystemTemplateRequest(id, revisionNumber.map(value => value))
    def id: Urn
    def revisionNumber: Optional[Version]
    def getId: ZIO[Any, Nothing, Urn] = ZIO.succeed(id)
    def getRevisionNumber: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("revisionNumber", revisionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest
  ) extends zio.aws.iotthingsgraph.model.GetSystemTemplateRequest.ReadOnly {
    override val id: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.id())
    override val revisionNumber: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionNumber())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest
  ): zio.aws.iotthingsgraph.model.GetSystemTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
