package zio.aws.iotthingsgraph.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.iotthingsgraph.model.primitives.{
  UploadId,
  Timestamp,
  NamespaceName,
  Arn,
  Version
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetUploadStatusResponse(
    uploadId: UploadId,
    uploadStatus: zio.aws.iotthingsgraph.model.UploadStatus,
    namespaceArn: Optional[Arn] = Optional.Absent,
    namespaceName: Optional[NamespaceName] = Optional.Absent,
    namespaceVersion: Optional[Version] = Optional.Absent,
    failureReason: Optional[Iterable[String]] = Optional.Absent,
    createdDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse = {
    import GetUploadStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse
      .builder()
      .uploadId(UploadId.unwrap(uploadId): java.lang.String)
      .uploadStatus(uploadStatus.unwrap)
      .optionallyWith(
        namespaceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.namespaceArn)
      .optionallyWith(
        namespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.namespaceName)
      .optionallyWith(
        namespaceVersion.map(value => Version.unwrap(value): java.lang.Long)
      )(_.namespaceVersion)
      .optionallyWith(
        failureReason.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.failureReason)
      .createdDate(Timestamp.unwrap(createdDate): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetUploadStatusResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetUploadStatusResponse.wrap(buildAwsValue())
}
object GetUploadStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetUploadStatusResponse =
      zio.aws.iotthingsgraph.model.GetUploadStatusResponse(
        uploadId,
        uploadStatus,
        namespaceArn.map(value => value),
        namespaceName.map(value => value),
        namespaceVersion.map(value => value),
        failureReason.map(value => value),
        createdDate
      )
    def uploadId: UploadId
    def uploadStatus: zio.aws.iotthingsgraph.model.UploadStatus
    def namespaceArn: Optional[Arn]
    def namespaceName: Optional[NamespaceName]
    def namespaceVersion: Optional[Version]
    def failureReason: Optional[List[String]]
    def createdDate: Timestamp
    def getUploadId: ZIO[Any, Nothing, UploadId] = ZIO.succeed(uploadId)
    def getUploadStatus
        : ZIO[Any, Nothing, zio.aws.iotthingsgraph.model.UploadStatus] =
      ZIO.succeed(uploadStatus)
    def getNamespaceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("namespaceVersion", namespaceVersion)
    def getFailureReason: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreatedDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse
  ) extends zio.aws.iotthingsgraph.model.GetUploadStatusResponse.ReadOnly {
    override val uploadId: UploadId =
      zio.aws.iotthingsgraph.model.primitives.UploadId(impl.uploadId())
    override val uploadStatus: zio.aws.iotthingsgraph.model.UploadStatus =
      zio.aws.iotthingsgraph.model.UploadStatus.wrap(impl.uploadStatus())
    override val namespaceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceArn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val namespaceName: Optional[NamespaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.NamespaceName(value)
      )
    override val namespaceVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
    override val failureReason: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val createdDate: Timestamp =
      zio.aws.iotthingsgraph.model.primitives.Timestamp(impl.createdDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse
  ): zio.aws.iotthingsgraph.model.GetUploadStatusResponse.ReadOnly =
    new Wrapper(impl)
}
