package zio.aws.iotthingsgraph.model
import zio.prelude.data.Optional
import zio.aws.iotthingsgraph.model.primitives.{MaxResults, NextToken, Urn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetFlowTemplateRevisionsRequest(
    id: Urn,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest = {
    import GetFlowTemplateRevisionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest
      .builder()
      .id(Urn.unwrap(id): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsRequest
      .wrap(buildAwsValue())
}
object GetFlowTemplateRevisionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsRequest =
      zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsRequest(
        id,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def id: Urn
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getId: ZIO[Any, Nothing, Urn] = ZIO.succeed(id)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest
  ) extends zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsRequest.ReadOnly {
    override val id: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.id())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest
  ): zio.aws.iotthingsgraph.model.GetFlowTemplateRevisionsRequest.ReadOnly =
    new Wrapper(impl)
}
