package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Version, Urn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFlowTemplateRequest(
    id: Urn,
    definition: zio.aws.iotthingsgraph.model.DefinitionDocument,
    compatibleNamespaceVersion: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest = {
    import UpdateFlowTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest
      .builder()
      .id(Urn.unwrap(id): java.lang.String)
      .definition(definition.buildAwsValue())
      .optionallyWith(
        compatibleNamespaceVersion.map(value =>
          Version.unwrap(value): java.lang.Long
        )
      )(_.compatibleNamespaceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.UpdateFlowTemplateRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.UpdateFlowTemplateRequest.wrap(buildAwsValue())
}
object UpdateFlowTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.UpdateFlowTemplateRequest =
      zio.aws.iotthingsgraph.model.UpdateFlowTemplateRequest(
        id,
        definition.asEditable,
        compatibleNamespaceVersion.map(value => value)
      )
    def id: Urn
    def definition: zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    def compatibleNamespaceVersion: Optional[Version]
    def getId: ZIO[Any, Nothing, Urn] = ZIO.succeed(id)
    def getDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = ZIO.succeed(definition)
    def getCompatibleNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField(
        "compatibleNamespaceVersion",
        compatibleNamespaceVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest
  ) extends zio.aws.iotthingsgraph.model.UpdateFlowTemplateRequest.ReadOnly {
    override val id: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.id())
    override val definition
        : zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly =
      zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(impl.definition())
    override val compatibleNamespaceVersion: Optional[Version] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compatibleNamespaceVersion())
        .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest
  ): zio.aws.iotthingsgraph.model.UpdateFlowTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
