package zio.aws.iotthingsgraph.model
import zio.prelude.data.Optional
import zio.aws.iotthingsgraph.model.primitives.{Version, MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchEntitiesRequest(
    entityTypes: Iterable[zio.aws.iotthingsgraph.model.EntityType],
    filters: Optional[Iterable[zio.aws.iotthingsgraph.model.EntityFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    namespaceVersion: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest = {
    import SearchEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest
      .builder()
      .entityTypesWithStrings(entityTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        namespaceVersion.map(value => Version.unwrap(value): java.lang.Long)
      )(_.namespaceVersion)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SearchEntitiesRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.SearchEntitiesRequest.wrap(buildAwsValue())
}
object SearchEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SearchEntitiesRequest =
      zio.aws.iotthingsgraph.model.SearchEntitiesRequest(
        entityTypes,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value),
        namespaceVersion.map(value => value)
      )
    def entityTypes: List[zio.aws.iotthingsgraph.model.EntityType]
    def filters
        : Optional[List[zio.aws.iotthingsgraph.model.EntityFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def namespaceVersion: Optional[Version]
    def getEntityTypes
        : ZIO[Any, Nothing, List[zio.aws.iotthingsgraph.model.EntityType]] =
      ZIO.succeed(entityTypes)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.iotthingsgraph.model.EntityFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("namespaceVersion", namespaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest
  ) extends zio.aws.iotthingsgraph.model.SearchEntitiesRequest.ReadOnly {
    override val entityTypes: List[zio.aws.iotthingsgraph.model.EntityType] =
      impl
        .entityTypes()
        .asScala
        .map { item =>
          zio.aws.iotthingsgraph.model.EntityType.wrap(item)
        }
        .toList
    override val filters
        : Optional[List[zio.aws.iotthingsgraph.model.EntityFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotthingsgraph.model.EntityFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
    override val namespaceVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest
  ): zio.aws.iotthingsgraph.model.SearchEntitiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
