package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.GreengrassDeploymentId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeploySystemInstanceResponse(
    summary: zio.aws.iotthingsgraph.model.SystemInstanceSummary,
    greengrassDeploymentId: Optional[GreengrassDeploymentId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse = {
    import DeploySystemInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse
      .builder()
      .summary(summary.buildAwsValue())
      .optionallyWith(
        greengrassDeploymentId.map(value =>
          GreengrassDeploymentId.unwrap(value): java.lang.String
        )
      )(_.greengrassDeploymentId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse
      .wrap(buildAwsValue())
}
object DeploySystemInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse =
      zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse(
        summary.asEditable,
        greengrassDeploymentId.map(value => value)
      )
    def summary: zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
    def greengrassDeploymentId: Optional[GreengrassDeploymentId]
    def getSummary: ZIO[
      Any,
      Nothing,
      zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly
    ] = ZIO.succeed(summary)
    def getGreengrassDeploymentId: ZIO[Any, AwsError, GreengrassDeploymentId] =
      AwsError.unwrapOptionField(
        "greengrassDeploymentId",
        greengrassDeploymentId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse
  ) extends zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse.ReadOnly {
    override val summary
        : zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly =
      zio.aws.iotthingsgraph.model.SystemInstanceSummary.wrap(impl.summary())
    override val greengrassDeploymentId: Optional[GreengrassDeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greengrassDeploymentId())
        .map(value =>
          zio.aws.iotthingsgraph.model.primitives.GreengrassDeploymentId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse
  ): zio.aws.iotthingsgraph.model.DeploySystemInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
