package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Version, Urn, ThingName}
import scala.jdk.CollectionConverters.*
final case class AssociateEntityToThingRequest(
    thingName: ThingName,
    entityId: Urn,
    namespaceVersion: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest = {
    import AssociateEntityToThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .entityId(Urn.unwrap(entityId): java.lang.String)
      .optionallyWith(
        namespaceVersion.map(value => Version.unwrap(value): java.lang.Long)
      )(_.namespaceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.AssociateEntityToThingRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.AssociateEntityToThingRequest
      .wrap(buildAwsValue())
}
object AssociateEntityToThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.AssociateEntityToThingRequest =
      zio.aws.iotthingsgraph.model.AssociateEntityToThingRequest(
        thingName,
        entityId,
        namespaceVersion.map(value => value)
      )
    def thingName: ThingName
    def entityId: Urn
    def namespaceVersion: Option[Version]
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getEntityId: ZIO[Any, Nothing, Urn] = ZIO.succeed(entityId)
    def getNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("namespaceVersion", namespaceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest
  ) extends zio.aws.iotthingsgraph.model.AssociateEntityToThingRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iotthingsgraph.model.primitives.ThingName(impl.thingName())
    override val entityId: Urn =
      zio.aws.iotthingsgraph.model.primitives.Urn(impl.entityId())
    override val namespaceVersion: Option[Version] = scala
      .Option(impl.namespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest
  ): zio.aws.iotthingsgraph.model.AssociateEntityToThingRequest.ReadOnly =
    new Wrapper(impl)
}
