package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetFlowTemplateResponse(
    description: Option[zio.aws.iotthingsgraph.model.FlowTemplateDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse = {
    import GetFlowTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse
      .builder()
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetFlowTemplateResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetFlowTemplateResponse.wrap(buildAwsValue())
}
object GetFlowTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetFlowTemplateResponse =
      zio.aws.iotthingsgraph.model
        .GetFlowTemplateResponse(description.map(value => value.asEditable))
    def description
        : Option[zio.aws.iotthingsgraph.model.FlowTemplateDescription.ReadOnly]
    def getDescription: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.FlowTemplateDescription.ReadOnly
    ] = AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse
  ) extends zio.aws.iotthingsgraph.model.GetFlowTemplateResponse.ReadOnly {
    override val description: Option[
      zio.aws.iotthingsgraph.model.FlowTemplateDescription.ReadOnly
    ] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.iotthingsgraph.model.FlowTemplateDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse
  ): zio.aws.iotthingsgraph.model.GetFlowTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
