package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotthingsgraph.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Iterable[zio.aws.iotthingsgraph.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.TagResourceRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.TagResourceRequest =
      zio.aws.iotthingsgraph.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArn
    def tags: List[zio.aws.iotthingsgraph.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.iotthingsgraph.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest
  ) extends zio.aws.iotthingsgraph.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.iotthingsgraph.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.iotthingsgraph.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iotthingsgraph.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest
  ): zio.aws.iotthingsgraph.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
