package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSystemTemplateResponse(
    description: Option[
      zio.aws.iotthingsgraph.model.SystemTemplateDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse = {
    import GetSystemTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse
      .builder()
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.wrap(buildAwsValue())
}
object GetSystemTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetSystemTemplateResponse =
      zio.aws.iotthingsgraph.model
        .GetSystemTemplateResponse(description.map(value => value.asEditable))
    def description: Option[
      zio.aws.iotthingsgraph.model.SystemTemplateDescription.ReadOnly
    ]
    def getDescription: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemTemplateDescription.ReadOnly
    ] = AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse
  ) extends zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly {
    override val description: Option[
      zio.aws.iotthingsgraph.model.SystemTemplateDescription.ReadOnly
    ] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.iotthingsgraph.model.SystemTemplateDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse
  ): zio.aws.iotthingsgraph.model.GetSystemTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
