package zio.aws.iotthingsgraph
import zio.prelude.Subtype
import zio.aws.iotthingsgraph.model.primitives.{
  FlowTemplateFilterValue,
  Urn,
  EntityFilterValue,
  SystemInstanceFilterValue,
  SystemTemplateFilterValue,
  TagKey
}
import java.time.Instant
import zio.aws.iotthingsgraph.model.primitives.DefinitionText.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.iotthingsgraph.model.primitives.Arn.Type
    object DefinitionText extends Subtype[String]
    type DefinitionText =
      zio.aws.iotthingsgraph.model.primitives.DefinitionText.Type
    object DeprecateExistingEntities extends Subtype[Boolean]
    type DeprecateExistingEntities =
      zio.aws.iotthingsgraph.model.primitives.DeprecateExistingEntities.Type
    object Enabled extends Subtype[Boolean]
    type Enabled = zio.aws.iotthingsgraph.model.primitives.Enabled.Type
    object EntityFilterValue extends Subtype[String]
    type EntityFilterValue =
      zio.aws.iotthingsgraph.model.primitives.EntityFilterValue.Type
    object FlowExecutionId extends Subtype[String]
    type FlowExecutionId =
      zio.aws.iotthingsgraph.model.primitives.FlowExecutionId.Type
    object FlowExecutionMessageId extends Subtype[String]
    type FlowExecutionMessageId =
      zio.aws.iotthingsgraph.model.primitives.FlowExecutionMessageId.Type
    object FlowExecutionMessagePayload extends Subtype[String]
    type FlowExecutionMessagePayload =
      zio.aws.iotthingsgraph.model.primitives.FlowExecutionMessagePayload.Type
    object FlowTemplateFilterValue extends Subtype[String]
    type FlowTemplateFilterValue =
      zio.aws.iotthingsgraph.model.primitives.FlowTemplateFilterValue.Type
    object GreengrassDeploymentId extends Subtype[String]
    type GreengrassDeploymentId =
      zio.aws.iotthingsgraph.model.primitives.GreengrassDeploymentId.Type
    object GreengrassGroupId extends Subtype[String]
    type GreengrassGroupId =
      zio.aws.iotthingsgraph.model.primitives.GreengrassGroupId.Type
    object GreengrassGroupVersionId extends Subtype[String]
    type GreengrassGroupVersionId =
      zio.aws.iotthingsgraph.model.primitives.GreengrassGroupVersionId.Type
    object GroupName extends Subtype[String]
    type GroupName = zio.aws.iotthingsgraph.model.primitives.GroupName.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.iotthingsgraph.model.primitives.MaxResults.Type
    object NamespaceName extends Subtype[String]
    type NamespaceName =
      zio.aws.iotthingsgraph.model.primitives.NamespaceName.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.iotthingsgraph.model.primitives.NextToken.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.iotthingsgraph.model.primitives.ResourceArn.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.iotthingsgraph.model.primitives.RoleArn.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName =
      zio.aws.iotthingsgraph.model.primitives.S3BucketName.Type
    object SyncWithPublicNamespace extends Subtype[Boolean]
    type SyncWithPublicNamespace =
      zio.aws.iotthingsgraph.model.primitives.SyncWithPublicNamespace.Type
    object SystemInstanceFilterValue extends Subtype[String]
    type SystemInstanceFilterValue =
      zio.aws.iotthingsgraph.model.primitives.SystemInstanceFilterValue.Type
    object SystemTemplateFilterValue extends Subtype[String]
    type SystemTemplateFilterValue =
      zio.aws.iotthingsgraph.model.primitives.SystemTemplateFilterValue.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.iotthingsgraph.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.iotthingsgraph.model.primitives.TagValue.Type
    object ThingArn extends Subtype[String]
    type ThingArn = zio.aws.iotthingsgraph.model.primitives.ThingArn.Type
    object ThingName extends Subtype[String]
    type ThingName = zio.aws.iotthingsgraph.model.primitives.ThingName.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.iotthingsgraph.model.primitives.Timestamp.Type
    object UploadId extends Subtype[String]
    type UploadId = zio.aws.iotthingsgraph.model.primitives.UploadId.Type
    object Urn extends Subtype[String]
    type Urn = zio.aws.iotthingsgraph.model.primitives.Urn.Type
    object Version extends Subtype[Long]
    type Version = zio.aws.iotthingsgraph.model.primitives.Version.Type
  }
  type DependencyRevisions =
    List[zio.aws.iotthingsgraph.model.DependencyRevision]
  type EntityDescriptions = List[zio.aws.iotthingsgraph.model.EntityDescription]
  type EntityFilterValues = List[EntityFilterValue]
  type EntityFilters = List[zio.aws.iotthingsgraph.model.EntityFilter]
  type EntityTypes = List[zio.aws.iotthingsgraph.model.EntityType]
  type FlowExecutionMessages =
    List[zio.aws.iotthingsgraph.model.FlowExecutionMessage]
  type FlowExecutionSummaries =
    List[zio.aws.iotthingsgraph.model.FlowExecutionSummary]
  type FlowTemplateFilterValues = List[FlowTemplateFilterValue]
  type FlowTemplateFilters =
    List[zio.aws.iotthingsgraph.model.FlowTemplateFilter]
  type FlowTemplateSummaries =
    List[zio.aws.iotthingsgraph.model.FlowTemplateSummary]
  type StringList = List[String]
  type SystemInstanceFilterValues = List[SystemInstanceFilterValue]
  type SystemInstanceFilters =
    List[zio.aws.iotthingsgraph.model.SystemInstanceFilter]
  type SystemInstanceSummaries =
    List[zio.aws.iotthingsgraph.model.SystemInstanceSummary]
  type SystemTemplateFilterValues = List[SystemTemplateFilterValue]
  type SystemTemplateFilters =
    List[zio.aws.iotthingsgraph.model.SystemTemplateFilter]
  type SystemTemplateSummaries =
    List[zio.aws.iotthingsgraph.model.SystemTemplateSummary]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.iotthingsgraph.model.Tag]
  type Things = List[zio.aws.iotthingsgraph.model.Thing]
  type Urns = List[Urn]
}
